function den_est=nonpriv_density_est(beta,r2,X,t)
    n=length(X);
    d=round((n*r2)^(1/(2*beta+1)));
    ortho_coeff=zeros(1,d);
    for i=1:n
        for j=1:d
            if mod(j,2)==1
                ortho_coeff(j)=ortho_coeff(j)+sqrt(2)*sin(pi*(j-1)*X(i));
            end
            if mod(j,2)==0
                ortho_coeff(j)=ortho_coeff(j)+sqrt(2)*cos(pi*j*X(i));
            end
        end
    end
    ortho_coeff=ortho_coeff/n;
    den_est=zeros(1,length(t));
    for k=1:d
        if mod(k,2)==1
            den_est=den_est+ortho_coeff(k)*sqrt(2)*sin(pi*(k-1)*t);
        end
        if mod(k,2)==0
            den_est=den_est+ortho_coeff(k)*sqrt(2)*cos(pi*k*t);
        end
    end
    den_est=ones(1,length(t))+den_est;
end